using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Outbound_OpenInterface_Test_App.OutboundCampaignWS;
using System.Web.Services.Protocols;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Get_Contact_ID : Form
  {
    OWCampaigns This_Campaign_List;
    int This_Selected_Index;


    public Get_Contact_ID(OWCampaigns Campaign_List, int Selected_Index)
    {
      InitializeComponent();
      This_Campaign_List = Campaign_List;
      This_Selected_Index = Selected_Index;
      Campaign_Name_Field.Text = This_Campaign_List.CampaignList[This_Selected_Index].Name;
    }

    /// <summary>
    /// Get contact ID bt phone number
    /// </summary>
    /// <param name="Campaign_List"></param>
    /// <param name="Selected_Index"></param>
    private void Get_ID_Button_Click(object sender, EventArgs e)
    {
     //will return the first contact with the entered contact number
      
      OutboundContactWS.OutboundContactWS contInvoke = new OutboundContactWS.OutboundContactWS();
      OutboundContactWS.OWPhoneNumber ContactNo = new OutboundContactWS.OWPhoneNumber();
      
      long contactID = 0;
      
      ContactNo.AreaCode = Area_Code_Field.Text;
      ContactNo.IntCode = Int_Code_Field.Text;
      ContactNo.PhoneNo = Phone_No_Field.Text;


      try
      {
        contactID = contInvoke.GetContactIDByPhoneNumber(ContactNo, (int)This_Campaign_List.CampaignList[This_Selected_Index].ID, GlobalDef.getInstance().MySessionKey);
        
        Message_Label.Text = "";
        Message_Label.Refresh();
      }
      catch(SoapException ex)
      {
        //message here....
      }

      if(contactID == -1)
        Message_Label.Text = "Contact not found";
      else
        Message_Label.Text = "Contact ID = " + contactID;

      Message_Label.Refresh();
    }
  }
}